/**
 *  Copyright 2003-2023 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of SeBIE.
 *
 *  SeBIE is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SeBIE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SeBIE; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef _SEBIE_CONFIG_H_
#define _SEBIE_CONFIG_H_  1

typedef enum sebie_config_type_e {
  CONFIG_END,
  CONFIG_INTEGER,
  CONFIG_DOUBLE,
  CONFIG_STRING
} sebie_config_type;

typedef struct sebie_config_spec_s {
  const char *name;
  sebie_config_type type;
  union storage_u {
    int    *integer;
    double *doublev;
    char   **string;
  } storage;
  union defvalue_u {
    int    integer;
    double doublev;
    const char *string;
  } defvalue;
} sebie_config_spec;

int sebie_read_config(const char *path, sebie_config_spec *spec);
int sebie_write_config(const char *path, sebie_config_spec *spec);

#endif /* _SEBIE_CONFIG_H_ */
