/**
 *  Copyright 2002-2023 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of SeBIE.
 *
 *  SeBIE is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SeBIE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SeBIE; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef _SEBIE_CALLBACKS_H_
#define _SEBIE_CALLBACKS_H_  1

#include <gtk/gtk.h>

#if GTK_CHECK_VERSION(4,10,0)
void
on_file_list_single_selection_changed (GtkSingleSelection *selection,
                                       guint position,
                                       guint n_items,
                                       gpointer user_data);
#else
void
on_treeview_file_list_changed (GtkTreeSelection *selection,
                               gpointer user_data);
#endif


void
on_entry_input_path_changed (GtkEditable *editable,
                             gpointer user_data);

void
on_entry_input_regex_changed (GtkEditable *editable,
                              gpointer user_data);

void
on_entry_output_format_changed (GtkEditable *editable,
                                gpointer user_data);
gint
window1_delete_event (GtkWidget *widget,
                      GdkEvent *event,
                      gpointer data);

void
window1_destroy (GtkWidget *widget,
                 gpointer data);

#if GTK_CHECK_VERSION(4,0,0)
void
drawingarea1_resize (GtkWidget *widget,
                     gint width,
                     gint height,
                     gpointer data);
#else
void
drawingarea1_size_allocate (GtkWidget *widget,
                            GtkAllocation *allocation,
                            gpointer data);
#endif

void
on_button_quit_clicked (GtkButton *button,
                        gpointer user_data);

void
on_button_save_clicked (GtkButton *button,
                        gpointer user_data);

void
on_button_rotate_left_clicked (GtkButton *button,
                               gpointer user_data);

void
on_button_rotate_right_clicked (GtkButton *button,
                                gpointer user_data);

void
on_entry_selection_fac_width_changed (GtkEditable *editable,
                                      gpointer user_data);

void
on_entry_selection_fac_height_changed (GtkEditable *editable,
                                       gpointer user_data);

void
on_button_fac_swap (GtkButton *button,
                    gpointer user_data);

void
on_entry_selection_gamma_changed (GtkEditable *editable,
                                  gpointer user_data);

#if GTK_CHECK_VERSION(4,0,0)
void
on_button_grayscale_clicked(GtkToggleButton *button,
                            gpointer user_data);
#elif GTK_CHECK_VERSION(3,0,0)
void
on_button_grayscale_clicked(GtkToolItem *button,
                            gpointer user_data);
#else
void
on_button_grayscale_clicked(GtkToggleButton *button,
                            gpointer user_data);
#endif

#if GTK_CHECK_VERSION(4,0,0)
void
drawingarea1_draw_function(GtkDrawingArea *area,
                           cairo_t *cr,
                           int width,
                           int height,
                           gpointer user_data);

void
on_drawingarea1_drag_begin(GtkGestureDrag *gesture,
                           double x,
                           double y,
                           gpointer user_data);

void
on_drawingarea1_drag_update(GtkGestureDrag *gesture,
                            double xmove,
                            double ymove,
                            gpointer user_data);

void
on_drawingarea1_drag_end(GtkGestureDrag *gesture,
                         double xmove,
                         double ymove,
                         gpointer user_data);

void
on_drawingarea1_motion(GtkEventControllerMotion *controller,
                       double x,
                       double y,
                       gpointer user_data);
#else
gboolean
on_drawingarea1_expose_event (GtkWidget *widget,
                              GdkEventExpose *event,
                              gpointer user_data);

gboolean
on_drawingarea1_button_press_event (GtkWidget *widget,
                                    GdkEventButton *event,
                                    gpointer user_data);

gboolean
on_drawingarea1_motion_notify_event (GtkWidget *widget,
                                     GdkEventMotion *event,
                                     gpointer user_data);
#endif

#if !GTK_CHECK_VERSION(4,10,0)
#if GTK_CHECK_VERSION(4,0,0)
void
on_error_dialog_response (GtkDialog *dialog,
                          int response,
                          gpointer user_data);
#endif
#endif

#endif /* _SEBIE_CALLBACKS_H_ */
