/**
 *  Copyright 2002 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of Jardin.
 *
 *  Jardin is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Jardin is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Foobar; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
package javacard.framework;

import java.lang.ArrayIndexOutOfBoundsException;
import java.lang.NullPointerException;
import javacard.framework.TransactionException;

public class Util extends java.lang.Object {

	public static byte arrayCompare(byte[] src, short srcOff, byte[] dest, short destOff, short length) throws ArrayIndexOutOfBoundsException, NullPointerException {
		if (srcOff < 0 || destOff < 0  || length < 0) {
			throw new ArrayIndexOutOfBoundsException();
		}

		if (src == null || dest == null) {
			throw new NullPointerException();
		}

		if ((short)(srcOff + length) > src.length) {
			throw new ArrayIndexOutOfBoundsException();
		}

		if ((short)(destOff + length) > dest.length) {
			throw new ArrayIndexOutOfBoundsException();
		}

		for (short i = 0; i < length; i++) {
			if (src[(short)(srcOff + i)] < dest[(short)(destOff + i)] ) {
				return -1;
			} else if (src[(short)(srcOff + i)] > dest[(short)(destOff + i)] ) {
				return 1;
			} 
                }
               return 0;
	}

	public static short arrayCopy(byte[] src, short srcOff, byte[] dest, short destOff, short length) throws ArrayIndexOutOfBoundsException, NullPointerException, TransactionException {
		return arrayCopyNonAtomic(src, srcOff, dest, destOff, length);
	}

	public static short arrayCopyNonAtomic(byte[] src, short srcOff, byte[] dest, short destOff, short length) throws ArrayIndexOutOfBoundsException, NullPointerException {
		if (srcOff < 0 || destOff < 0  || length < 0) {
			throw new ArrayIndexOutOfBoundsException();
		}

		if (src == null || dest == null) {
			throw new NullPointerException();
		}

		if ((short)(srcOff + length) > src.length) {
			throw new ArrayIndexOutOfBoundsException();
		}

		if ((short)(destOff + length) > dest.length) {
			throw new ArrayIndexOutOfBoundsException();
		}

		// XXXXX to do: if src == dst
		for (short i = 0; i < length; i++) {
			dest[(short)(destOff + i)] = src[(short)(srcOff + i)];
		}
		return (short)(destOff + length);
	}

	public static short arrayFillNonAtomic(byte[] bArray, short bOff, short bLen, byte bValue) throws ArrayIndexOutOfBoundsException, NullPointerException {
		if (bOff < 0 || bLen < 0 ) {
			throw new ArrayIndexOutOfBoundsException();
		}

		if (bArray == null) {
			throw new NullPointerException();
		}

		if ((short)(bOff + bLen) > bArray.length) {
			throw new ArrayIndexOutOfBoundsException();
		}

		for (short i = 0; i < bLen; i++) {
			bArray[(short)(bOff + i)] = bValue;
		}
		return (short)(bOff + bLen);
	}

	public static short getShort(byte[] bArray, short bOff) {
		return (short)((bArray[bOff] << 8) | bArray[(short)(bOff + 1)]);
	}

	public static short makeShort(byte b1, byte b2) {
		return (short)((b1 << 8) | b2);
	}

	public static short setShort(byte[] bArray, short bOff, short sValue) throws TransactionException {
		bArray[bOff] = (byte)((sValue & (short)0xff00) >> (short)8);
		bArray[(short)(bOff + 1)] = (byte)(sValue & 0x00ff);
		return (short)(bOff + 2);
	}

}
