/**
 *  Copyright 2002 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of Jardin.
 *
 *  Jardin is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Jardin is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Foobar; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
package javacard.framework;

import java.lang.ClassCastException;

public class AID extends java.lang.Object {
	private byte aidLength;
	private byte[] aid;

	public AID(byte[] bArray, short offset, byte length) throws javacard.framework.SystemException {
		if ( length < 5 || length > 16 ) {
			throw new javacard.framework.SystemException(javacard.framework.SystemException.ILLEGAL_VALUE);
		}
		this.aid = new byte[16];
		for (short i = 0; i < length; i++) {
			this.aid[i] = bArray[(short)(offset + i)];
		}
		aidLength = length;
	}

	public boolean equals(byte[] bArray, short offset, byte length) {
		if (bArray == null) {
			return false;
		}
		if (length != this.aidLength) {
			return false;
		}
		for (short i = 0; i < this.aidLength; i++) {
			if (bArray[(short)(offset + i)] != this.aid[i]) {
				return false;
			}
		}
		return true;
	}

	public boolean equeals(Object anObject) {
		if (anObject == null) {
			return false;
		}
		AID anAID;
		try {
			anAID = (AID) anObject;
		} catch (ClassCastException ex) {
			return false;
		}
		return anAID.equals(this.aid, (short)0, aidLength);
	}

	public byte getByte(byte[] dest, short offset) {
		for(short i = 0; i < aidLength; i++) {
			dest[(short)(offset+i)] = this.aid[i];
		}
		return aidLength;
	}

	public boolean partialEquals(byte[] bArray, short offset, byte length) {
                if (bArray == null) {
                        return false;
                }
                if (length > this.aidLength) {
                        return false;
                }
                for (short i = 0; i < length; i++) {
                        if (bArray[(short)(offset + i)] != this.aid[i]) {
                                return false;
                        }
                }
                return true;
	}

	public boolean RIDEquals(AID otherAID) {
		return otherAID.partialEquals(this.aid, (short)0, (byte)5);
	}
}
