/**
 *  Copyright 2002 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of Jardin.
 *
 *  Jardin is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Jardin is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Foobar; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
#ifndef JARDIN_CAP_H
#define JARDIN_CAP_H 1

#define ACC_INT     0x01
#define ACC_EXPORT  0x02
#define ACC_APPLET  0x04


#define COMPONENT_Header               1
#define COMPONENT_Directory            2
#define COMPONENT_Applet               3
#define COMPONENT_Import               4
#define COMPONENT_ConstantPool         5
#define COMPONENT_Class                6
#define COMPONENT_Method               7
#define COMPONENT_StaticField          8
#define COMPONENT_ReferenceLocation    9
#define COMPONENT_Export              10
#define COMPONENT_Descriptor          11


typedef unsigned char  u1;
typedef unsigned short u2;


struct package_info {
  u1 minor_version;
  u1 major_version;
  u1 AID_length;
  u1 *AID;
};


struct header_component {
  u1 tag;
  u2 size;
  u1 magic[4];
  u1 minor_version;
  u1 major_version;
  u1 flags;
  struct package_info this_package;
};


struct static_field_size_info {
  u2 image_size;
  u2 array_init_count;
  u2 array_init_size;
};


struct custom_component_info {
  u1 component_tag;
  u2 size;
  u1 AID_length;
  u1 *AID;
};


struct directory_component {
  u1 tag;
  u2 size;
  u2 component_sizes[11];
  struct static_field_size_info static_field_size;
  u1 import_count;
  u1 applet_count;
  u1 custom_count;
  struct custom_component_info *custom_components;
};


struct applets {
  u1 AID_length;
  u1 *AID;
  u2 install_method_offset;
};

struct applet_component {
  u1 tag;
  u2 size;
  u1 count;
  struct applets *applets;
};


struct import_component {
  u1 tag;
  u2 size;
  u1 count;
  struct package_info *packages;
};


#define CONSTANT_Classref          1
#define CONSTANT_InstanceFieldref  2
#define CONSTANT_VirtualMethodref  3
#define CONSTANT_SuperMethodref    4
#define CONSTANT_StaticFieldref    5
#define CONSTANT_StaticMethodref   6

struct cp_info {
  u1 tag;
  u1 info[3];
};

struct constant_pool_component {
  u1 tag;
  u2 size;
  u2 count;
  struct cp_info *constant_pool;
};

union class_ref {
  u2 internal_class_ref;
  struct {
    u1 package_token;
    u1 class_token;
  } external_class_ref;
};

struct classref_info {
  u1 tag;
  union class_ref class_ref;
  u1 padding;
};

struct instance_fieldref {
  u1 tag;
  union class_ref class;
  u1 token;
};

struct virtual_methodref {
  u1 tag;
  union class_ref class;
  u1 token;
};

struct super_methodref {
  u1 tag;
  union class_ref class;
  u1 token;
};

/*
struct static_field_ref {
  union {
    struct {
      u1 padding;
      u2 offset;
    } internal_ref;
    struct {
      u1 package_token;
      u1 class_token;
      u1 token;
    } external_ref;
  } u; // XXXXX
};
*/

struct static_fieldref_info {
  u1 tag;
  union {
    struct {
      u1 padding;
      u2 offset;
    } internal_ref;
    struct {
      u1 package_token;
      u1 class_token;
      u1 token;
    } external_ref;
  } static_field_ref;
};

struct static_methodref_info {
  u1 tag;
  union {
    struct {
      u1 padding;
      u2 offset;
    } internal_ref;
    struct {
      u1 package_token;
      u1 class_token;
      u1 token;
    } external_ref;
  } static_field_ref;
};

#define INTERFACE_INFO_FLAGS(a)           ((a.bitfield & 0xf0)>>4)
#define INTERFACE_INFO_INTERFACE_COUNT(a) (a.bitfield  & 0x0f)

#define ACC_INTERFACE 0x8
#define ACC_SHAREABLE 0x4
 
struct interface_info {
  u1 bitfield;
  // { bit[4] flags, bit[4] interface_count}
  union class_ref *superinterfaces;
};

struct implemented_interface_info {
  union class_ref interface;
  u1 count;
  u1 *index;
};

#define CLASS_INFO_FLAGS(a)            ((a.bitfield & 0xf0)>>4)
#define CLASS_INFO_INTERFACE_COUNT(a)  (a.bitfield & 0x0f)

struct class_info {
  u1 bitfield; /* { bit[4] flags, bit[4] interface_count} */
  union class_ref super_class_ref;
  u1 declared_instance_size;
  u1 first_reference_token;
  u1 reference_count;
  u1 public_method_table_base;
  u1 public_method_table_count;
  u1 package_method_table_base;
  u1 package_method_table_count;
  u2 *public_virtual_method_table;
  u2 *package_virtual_method_table;
  struct implemented_interface_info *interfaces;
  /* for vm implementation */
  u2 cap_file_offset;
};

struct class_component {
  u1 tag;
  u2 size;
  struct interface_info *interfaces;
  struct class_info *classes;
  /* for vm implementation */
  int interface_count;
  int class_count;
};


struct exception_handler_info {
  u2 start_offset;
  u2 bitfield;
  // { bit[1] stop_bit; bit[15] active_length }
  u2 handler_offset;
  u2 catch_type_index;
};

#define ACC_EXTENDED 0x8
//#define ACC_ABSTRACT 0x4

#define METHOD_HEADER_INFO_FLAGS(a)       ((a.bitfield1&0xf0)>>4)
#define METHOD_HEADER_INFO_MAX_STACK(a)   (a.bitfield1&0x0f)
#define METHOD_HEADER_INFO_NARGS(a)       ((a.bitfield2&0xf0)>>4)
#define METHOD_HEADER_INFO_MAX_LOCALS(a)  (a.bitfield2&0x0f)

struct method_header_info {
  u1 bitfield1;
  // { bit[4] flags; bit[4] max_stack; }
  u1 bitfield2;
  // { bit[4] nargs; bit[4] max_locals; }
};

struct extended_header_info {
  u1 bitfield;
  u1 max_stack;
  u1 nargs;
  u1 max_locals;
};

struct method_info {
  struct method_header_info method_header;
  u1 *bytecodes;
  //
  u2 cap_file_offset;
};

struct method_component {
  u1 tag;
  u2 size;
  u1 handler_count;
  struct exception_handler_info *exception_handlers;
  struct method_info *methods;
  //
  u2 method_count;
};

struct array_init_info {
  u1 type;
  u2 count;
  u1 *values;
};

struct reference_location_component {
  u1 tag;
  u2 size;
  u2 byte_index_count;
  u1 *offsets_to_byte_indices;
  u2 byte2_index_count;
  u1 *offsets_to_byte2_indices;
};

struct class_export_info {
  u2 class_offset;
  u1 static_field_count;
  u1 static_method_count;
  u2 *static_field_offsets;
  u2 *static_method_offsets;
};

struct export_component {
  u1 tag;
  u2 size;
  u1 class_count;
  struct class_export_info *class_exports;
};

struct static_field_component {
  u1 tag;
  u2 size;
  u2 image_size;
  u2 reference_count;
  u2 array_init_count;
  struct array_init_info *array_init;
  u2 default_value_count;
  u2 non_default_value_count;
  u1 *non_default_values;
};

#define ACC_PUBLIC     0x01
#define ACC_PRIVATE    0x02
#define ACC_PROTECTED  0x04
#define ACC_STATIC     0x08
#define ACC_FINAL      0x10
#define ACC_ABSTRACT   0x40
#define ACC_INIT       0x80

struct field_descriptor_info {
  u1 token;
  u1 access_flags;
  union {
    union {
      struct {
	u1 padding;
	u2 offset;
      } internal_ref;
      struct {
	u1 package_token;
	u1 class_token;
	u1 token;
      } external_ref;
    } static_field;
    struct {
      union class_ref class;
      u1 token;
    } instance_field;
  } field_ref;
  union {
#define BOOLEAN_TYPE 0x0002
#define BYTE_TYPE    0x0003
#define SHORT_TYPE   0x0004
#define INT_TYPE     0x0005
    u2 primitive_type;

    u2 reference_type;
  } type;
};

struct method_descriptor_info {
  u1 token;
  u1 access_flags;
  u2 method_offset;
  u2 type_offset;
  u2 bytecode_count;
  u2 exception_handler_count;
  u2 exception_handler_index;
  //
  struct method_info *method_info;
};
 
struct type_desriptor_info {
  u2 constant_pool_count;
  u2 *constant_pool_types;
  struct {
    u1 nibble_count;
    //#define VOID_TYPE    0x1
    //#define BOOLEAN_TYPE 0x2
    //#define BYTE_TYPE 0x3
    //#define SHORT_TYPE 0x4
    //#define INT_TYPE 0x5
#define REFERENCE_TYPE 0x6
#define ARRAY_OF_BOOLEAN_TYPE 0xa
#define ARRAY_OF_BYTE_TYPE 0xb
#define ARRAY_OF_SHORT_TYPE 0xc
#define ARRAY_OF_INT_TYPE 0xd
#define ARRAY_OF_REFERENCE_TYPE 0xe
    u1 *type;
  } *type_desc;
};


#define ACC_PUBLIC     0x01
#define ACC_FINAL      0x10
//#define ACC_INTERFACE  0x40
//#define ACC_ABSTRACT   0x80

struct class_descriptor_info {
  u1 token;
  u1 access_flags;
  union class_ref this_class_ref;
  u1 interface_count;
  u2 field_count;
  u2 method_count;
  union class_ref *interfaces;
  struct field_descriptor_info *fields;
  struct method_descriptor_info *methods;
};

struct struct_type_desc {
  u1 nibble_count;
  u1 *type;
};

struct type_descriptor_info {
  u2 constant_pool_count;
  u2 *constant_pool_types;
  struct struct_type_desc *type_desc;
  /* for the vm implementation */
  int type_desc_count;
};

struct descriptor_component {
  u1 tag;
  u2 size;
  u1 class_count;
  struct class_descriptor_info *classes;
  struct type_descriptor_info types;
};

struct jardin_cap {
  struct header_component         header_comp;
  struct directory_component      directory_comp;
  struct applet_component         applet_comp;
  struct import_component         import_comp;
  struct constant_pool_component  constant_pool_comp;
  struct class_component          class_comp;
  struct descriptor_component     descriptor_comp;
  struct method_component         method_comp;
  struct static_field_component   static_field_comp;
  struct reference_location_component ref_location_comp;
  struct export_component         export_comp;
};

void jardin_cap_read_files(struct jardin_cap **cap, char *path);

void jardin_cap_free(struct jardin_cap **cap);

#endif /* JARDIN_CAP_H */
