/**
 *  Copyright 2002 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of Jardin.
 *
 *  Jardin is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Jardin is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Foobar; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
#include "jardin_jcvm.h"
#include "jardin_cap.h"
#include "jardin_debug.h"

#include <mcheck.h>
#include <libgen.h>


int main(int argc, char **argv) {
  unsigned int applet_count = argc - 1;
  unsigned int i;
 
  mtrace();
  
  jardin_debug_init();

  if (argc < 2) {
    JARDIN_FATAL("Usage: %s <cap_file_path_0> <cap_file_path_1> ...", basename(argv[0]));
  }
  
  jardin_jcvm_applet_alloc(applet_count);
  
  for (i = 0; i < applet_count; i++) {
    jardin_cap_read_files(&jardin_jcvm_applets[i].cap, argv[i+1]);
    
  }

  jardin_jcvm_init();
   
  jardin_jcvm_run(2); /* run static install method from the third applet */
 
  jardin_jcvm_free();
  
  jardin_jcvm_applet_free();
  exit(0);
}
