<?xml version="1.0" encoding="ISO-8859-1"?>

<!--
  Copyright 2002 Peter Seiderer <Peter.Seiderer@ciselant.de>

  This file is part of Jardin.

  Jardin is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  Jardin is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Foobar; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

 <xsl:param name="page">0</xsl:param>

 <xsl:template match="/">
  <html>
   <head>
    <title>Jardin</title>
   </head>
   <body bgcolor="#ffffff" link="#000000" vlink="#000000" alink="#000000">
    <table border="0" cellspacing="0" cellpadding="0" width="100%">
     <!-- Header -->
     <tr><td colspan="2"><xsl:call-template name="page_header" /></td></tr>
     
     <tr>
      <!-- Navigation -->
      <td bgcolor="#f0f0f0" valign="top" width="125">
       <xsl:call-template name="page_navigation" />
      </td>
      <!-- Content -->
      <td width="85%" valign="top" rowspan="2">
       <xsl:call-template name="page_content" />     
      </td>
     </tr>
     <!-- down-left-field -->
     <tr>
      <td bgcolor="#e0e0e0" valign="top" width="125">
        <table border="0" cellpadding="10">
         <tr><td>
          <b>Legal:</b>
          <p>Java and Java Card are Trademarks of Sun Microsystems, Inc.</p>
         </td></tr>
        </table>
      </td>
     </tr>
    </table>
   </body>
  </html>
 </xsl:template>

 <xsl:template name="page_header">
  <center><h1><font color="steelblue">Jardin</font></h1></center>
 </xsl:template>

 <xsl:template name="page_navigation">
  <table border="0" cellpadding="10">
   <tr><td>
     <xsl:apply-templates select="/Jardin/Section" mode="page_navigation"/>
   </td></tr>
  </table>
 </xsl:template>

 <xsl:template match="Section" mode="page_navigation">
  <!-- Online -->
  <!-- -->
  <p><a><xsl:attribute name="href">jardin?page=<xsl:value-of select="@tag" /></xsl:attribute><xsl:value-of select="Title" /></a></p>
  <!-- -->
  <!-- Offline -->
  <!--
  <p><a><xsl:attribute name="href">jardin_page=<xsl:value-of select="@tag" />.html</xsl:attribute><xsl:value-of select="Title" /></a></p>
  -->
 </xsl:template>

 <xsl:template name="page_content">
  <table border="0" cellpadding="10">
   <tr><td>
      
      <xsl:apply-templates select="/Jardin/Section[@tag=$page]" mode="page_content"/>

    <hr/>
    copyright  2002 <a href="mailto:Peter.Seiderer@ciselant.de">Peter.Seiderer@ciselant.de</a><br/>
     Last modified: <xsl:value-of select="/Jardin/@date"/>
    </td></tr>
   </table>
 </xsl:template>

 <xsl:template match="Section" mode="page_content" >
  <xsl:apply-templates mode="page_content" />
 </xsl:template>

 <xsl:template match="Title" mode="page_content" >
   <h1><xsl:value-of select="." /></h1>
 </xsl:template>

 <xsl:template match="HtmlContent" mode="page_content" >
   <xsl:copy-of select="*|text()" />
 </xsl:template>

 <xsl:template match="Download" mode="page_content" >
   <table border="1" >
    <tr>
     <td valign="top">version</td>
     <td valign="top">file</td>
     <td valign="top">size</td>
     <td valign="top">date</td>
     <td valign="top">comment</td>
    </tr>
    <xsl:apply-templates select="Item" mode="page_content"/>
   </table>
 </xsl:template>

 <xsl:template match="Item" mode="page_content" >
   <tr>
    <td valign="top"><xsl:value-of select="@version" /></td>
    <td valign="top"><a><xsl:attribute name="href"><xsl:value-of select="@src" /></xsl:attribute><xsl:value-of select="@src" /></a></td>
    <td valign="top"><xsl:value-of select="@size" /></td>
    <td valign="top"><xsl:value-of select="@date" /></td>
    <td valign="top"><xsl:value-of select="." /></td>
   </tr>
 </xsl:template>

</xsl:stylesheet>

